<?xml version="1.0"?>
<!-- Written by Peter Mertens "peter@pmertens.de" -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:import href="kunde-html-incl.xsl"/>
	<xsl:template match="/Kundendaten">
		<xsl:processing-instruction name="cocoon-format">type="text/html"</xsl:processing-instruction>
		<html>
			<head>
				<title>
Kundendaten der </title>
			</head>
			<body bgcolor="#ffffff">
				<h4>
					<xsl:value-of select="Vorname"/>, <xsl:value-of select="Nachname"/>, <xsl:value-of select="Kundennummer"/>, Geburtsdatum: <xsl:value-of select="Geburtsdatum"/>
					<xsl:if test='Geschlecht="m"'>, maennlich, </xsl:if>
					<xsl:if test='Geschlecht="w"'>, weiblich, </xsl:if>
					<xsl:value-of select="Familienstand"/>, <xsl:value-of select="Kundenart"/>
				</h4>
				<xsl:if test='Adresse!=""'>
					<table bgcolor="#C0C0C0" border="0" cellpadding="0" cellspacing="0" width="100%">
						<tr>
							<td width="100%">
								<table bgcolor="#C0C0C0" cellpadding="0" border="0" width="50%" cellspacing="10">
									<xsl:apply-templates select="Adresse"/>
								</table>
							</td>
						</tr>
					</table>
					<hr/>
				</xsl:if>
				<table bgcolor="#C0C0C0" border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td width="100%">
							<xsl:if test='Konto!=""'>
								<table bgcolor="#C0C0C0" cellpadding="0" border="0" width="100%" cellspacing="10">
									<xsl:apply-templates select="Konto" mode="1">
										<xsl:sort select="Kontoart"/>
										<xsl:sort select="Kontonummer"/>
									</xsl:apply-templates>
								</table>
								<hr/>
								<xsl:apply-templates select="Konto" mode="2">
									<xsl:sort select="Kontoart"/>
									<xsl:sort select="Kontonummer"/>
								</xsl:apply-templates>
							</xsl:if>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
